/*------------------------------------------------------------------------------*
 * File Name: MatlabExportDlg.h													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED				*
 * Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX					*
 * Folger 07/16/07 OPEN_BROWSER_ACCORDING_TO_TAB_TYPE							*
 * Jasmine 07/24/07 USE_SNAME_IN_RANGE											*
 * Folger 07/24/07 CONTROL_REMOVE_BEHAVIOR										*
 * Folger 07/25/07 ADD_MATLAB_EXPORT_INFO										*
 * Folger 07/25/07 EXPORT_SELECTED_TO_MATLAB_ONLY								*
 * Jasmine 07/6/07 CANCEL_GRID_SELECTION										*
 * Folger 08/13/07 OPEN_COLUMN_AND_MATOBJ_BROWSER_WITH_RANGEBROWSER				*
 * Jasmine 09/28/07 QA70-10305 FILTER_OUT_NON_IMAGE_MATRIX						*
 *	fisher 11/23/07 ADD_MAP_ID_TO_CHM											*
 *	Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS			*
 *------------------------------------------------------------------------------*/

#ifndef _MATLAB_EXPORTDLG_H
#define _MATLAB_EXPORTDLG_H

#include <okocUtils.h>	//------Folger 07/25/07 ADD_MATLAB_EXPORT_INFO
///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
#include <externApps.h> // matlab class 
#include <o8dlg.h>

#define STR_NO_MATLAB "Matlab not available"
///end ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX

enum{TAB_COLUMN_TYPE, TAB_MATRIX_TYPE};
enum{COL_RANGE, COL_NAME};
//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
//typedef BOOL (*FUNC_VECTOR_STR_DWORD_HWND_BOOL_STR) (vector<string>& vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect, LPCSTR lpcszExcludeGraph);
typedef BOOL (*FUNC_VECTOR_STR_DWORD_HWND_BOOL_STR_BOOL) (vector<string>& vsResult, DWORD dwHwnd, HWND hWnd, bool bMultipleSelect, LPCSTR lpcszExcludeGraph, bool bResultSheet = false);
//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED

//------ Folger 08/13/07 OPEN_COLUMN_AND_MATOBJ_BROWSER_WITH_RANGEBROWSER
/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
//typedef BOOL (*FUNC_VECTOR_STR_HWND_INT_BOOL_BOOL_DWORD_STR) (vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL);
typedef BOOL (*FUNC_VECTOR_STR_HWND_INT_BOOL_BOOL_DWORD_STR) (vector<string>& vsResult, HWND hParent, int nPageType, bool bXYRange = false, bool bMultipleSelect = true, DWORD dwFilter = 0, LPCSTR lpcszDlg = NULL, UINT nSelectedColUID = 0);
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
//------ End OPEN_COLUMN_AND_MATOBJ_BROWSER_WITH_RANGEBROWSER

class MatExportDlg : public ResizeDialog
{
public:
	MatExportDlg() : ResizeDialog(IDD_MATLAB_EXPORT, "ODlg8")
	{
	}
	int DoModalEx(HWND hWndParent = NULL, LPCSTR lpcszMatlabWkspaceName = NULL, BOOL bSingle = FALSE)
	{
		InitMsgMap();// will be called from internal later
		m_strMatlabWorkspaceFilename = lpcszMatlabWkspaceName;   // the MAT file name
		m_bSingle = bSingle;									///	DVT should be connected to m_bRestoreWorkspace
		int nRet = ResizeDialog::DoModal(hWndParent);
		
		return nRet;
	}

protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	//ON_TIMER(OnTimer)	//doing
	ON_DESTROY(OnDestroy)
	ON_TAB_SEL_CHANGE(IDC_MATLAB_TAB, OnTabChange)
	ON_BN_CLICKED(IDC_MATLAB_SELECT_BTN, OnOpenBrowser)
	ON_BN_CLICKED(IDC_MATLAB_REMOVE_BTN, OnRemove)
	ON_BN_CLICKED(IDC_MATLAB_EXPORT_NUN_BTN, OnExport)
	//ON_BN_CLICKED(IDC_MATLAB_EXPORT_STR_BTN, OnExportStr) ///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
	ON_GRID_BEFORE_EDIT(IDC_MATLAB_GRID, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_MATLAB_GRID, OnAfterEdit)
	ON_HELPINFO(OnHelp)
EVENTS_END

	//------ fisher 11/16/07 ADD_MAP_ID_TO_CHM
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		nHelpID = IDD_MATLAB_EXP;
		return true;
	}

	BOOL OnInitDialog()
	{
		ResizeDialog::OnInitDialog();
		m_tab = GetItem(IDC_MATLAB_TAB);
		m_tab.InsertItem(TAB_COLUMN_TYPE, _L("Column"));
		m_tab.InsertItem(TAB_MATRIX_TYPE, _L("Matrix"));
		
		m_Varlist.Init(IDC_MATLAB_GRID, *this);
		m_Varlist.SetReady(false);
		m_Varlist.SetAllowSelection();
		m_Varlist.SetSelection(flexSelectionListBox);
		m_Varlist.SetEditable(flexEDKbdMouse);
		m_Varlist.SetupRowsCols(1, 0,  -1, 2);
		m_Varlist.SetColHeading(COL_RANGE + m_Varlist.GetColOffset(), _L("Range"));
		m_Varlist.SetColHeading(COL_NAME + m_Varlist.GetColOffset(), _L("Name"));
		m_Varlist.SetReady(true);
		
		GetItem(IDC_MATLAB_SELECT_BTN).Text = _L("Browse...");	///Jasmine 09/29/07 QA70-10044 CHANGE_SELECT_BUTTON_TO_BROWSER_BUTTON
		
		Page pg = Project.Pages();
		string strRange, strBook, strSheet, strObj, strSName;
		vector<string> vsRanges, vsNames;
		if(pg && EXIST_WKS == pg.GetType())
		{
			m_tab.SetCurSel(TAB_COLUMN_TYPE);
			Worksheet wks = pg.Layers();
			foreach(Column col in wks.Columns)
			{
				col.GetRangeString(strRange);
				strSName = col.GetName();	///Jasmine 07/24/07 USE_SNAME_IN_RANGE
				okutil_parse_complete_range_string(strRange, &strBook, &strSheet, &strObj);
				okutil_create_complete_range_string_obj(&strRange, strBook, strSheet, strSName);
				vsRanges.Add(strRange);
			}
		}
		if(pg && EXIST_MATRIX == pg.GetType())
		{
			m_tab.SetCurSel(TAB_MATRIX_TYPE);
			MatrixLayer ml = pg.Layers();
			foreach(MatrixObject mo in ml.MatrixObjects)
			{
				mo.GetRangeString(strRange);
				strSName = mo.GetName();
				okutil_parse_complete_range_string(strRange, &strBook, &strSheet, &strObj);
				okutil_create_complete_range_string_obj(&strRange, strBook, strSheet, strSName);
				vsRanges.Add(strRange);
			}
		}
		int nSize = vsRanges.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			string strName = GetVarNameFromRange(vsRanges[ii]);
			int nEnum = get_list_enum_number(vsNames, strName);
			if(nEnum)
				strName += (string)nEnum;
			vsNames.Add(strName);
		}
		setArrays(vsRanges, vsNames);
		UpdateVarList(vsRanges, vsNames);
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		uint nCntrlsRight[] = {IDC_MATLAB_SELECT_BTN, IDC_MATLAB_REMOVE_BTN, IDC_MATLAB_EXPORT_NUN_BTN, IDCANCEL, 0}; 				
		uint nCntrlsBottom[] = {0};				
		ResizeMoveControlsRightBottom(IDC_MATLAB_TAB, nCntrlsRight, nCntrlsBottom, cx, cy);
					
		RECT rTab;
		m_tab.GetWindowRect(&rTab);
		ScreenToClient(&rTab);
		m_tab.AdjustRect(FALSE, &rTab);
		GetItem(IDC_MATLAB_GRID).MoveWindow(&rTab);
		return TRUE;
	}	
	BOOL OnTabChange(Control ctrl)
	{
		vector<string> vsRanges, vsNames;
		getArrays(vsRanges, vsNames);
		UpdateVarList(vsRanges, vsNames);
		return TRUE;
	}
	BOOL OnOpenBrowser(Control ctrl)
	{
		vector<string> vsOldRanges, vsRanges, vsOldNames, vsNames;
		getArrays(vsOldRanges, vsOldNames);
		vsRanges = vsOldRanges;
		
		//------ Folger 08/13/07 OPEN_COLUMN_AND_MATOBJ_BROWSER_WITH_RANGEBROWSER
		//string strExcludePage, strPath = "Originlab\\ProjectBrowser.c";
		////-------Folger 07/16/07 OPEN_BROWSER_ACCORDING_TO_TAB_TYPE
		//////---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
		//////FUNC_VECTOR_STR_DWORD_HWND_BOOL_STR pfn = Project.FindFunction("ProjectBrowseColumns", strPath);
		////FUNC_VECTOR_STR_DWORD_HWND_BOOL_STR_BOOL pfn = Project.FindFunction("ProjectBrowseMatObjs", strPath);
		//////---------End EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
		//FUNC_VECTOR_STR_DWORD_HWND_BOOL_STR_BOOL pfn = NULL;
		//if (m_tab.GetCurSel() == TAB_MATRIX_TYPE)
			//pfn = Project.FindFunction("ProjectBrowseMatObjs", strPath);
		//else
			//pfn = Project.FindFunction("ProjectBrowseColumns", strPath);
		////-------End OPEN_BROWSER_ACCORDING_TO_TAB_TYPE
		//if(!pfn || !pfn(vsRanges, 0, GetSafeHwnd(), true, strExcludePage))
			//return FALSE;
			
		bool bXYRange = false;
		bool bMultipleSelect = true;
		bool bIsColumnBrowser = m_tab.GetCurSel() == TAB_COLUMN_TYPE;
		int nPageType = bIsColumnBrowser ? EXIST_WKS : EXIST_MATRIX;
		DWORD dwFilter = bIsColumnBrowser? SCD_NO_RESULT_SHEET : 0;	///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX, it seem no need to filter data matrix or image matrix when exporting to matlab
		string strDlgName = bIsColumnBrowser ? _L("Column Browser") : _L("Matrix Browser");
		string strPath = "Originlab\\RangeBrowser.c";
		FUNC_RANGE_BROWSER	pfn = Project.FindFunction("RangeBrowser", strPath);
		if(!pfn || !pfn(vsRanges, GetSafeHwnd(), nPageType, bXYRange, bMultipleSelect, dwFilter, strDlgName))///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX
			return false;
		//------ End OPEN_COLUMN_AND_MATOBJ_BROWSER_WITH_RANGEBROWSER
		
		int nSize = vsRanges.GetSize();
		vsNames.SetSize(nSize);
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = vsOldRanges.Find(vsRanges[ii]);
			if(0 <= nIndex)
				vsNames[ii] = vsOldNames[ii];
		}
		for(ii = 0; ii < nSize; ii++)
		{
			string strName = vsNames[ii];
			if(strName.IsEmpty())
			{
				string strName = GetVarNameFromRange(vsRanges[ii]);
				int nEnum = get_list_enum_number(vsNames, strName);
				if(nEnum)
					strName += (string)nEnum;
				vsNames[ii] = strName;
			}
		}		
		setArrays(vsRanges, vsNames);
		UpdateVarList(vsRanges, vsNames);
		return TRUE;
	}
	void UpdateVarList(const vector<string> vsRanges, const vector<string> vsNames)
	{
		m_Varlist.ClearAll();
		m_Varlist.SetColValues(COL_RANGE + m_Varlist.GetColOffset(), vsRanges, 0, true);
		m_Varlist.SetColValues(COL_NAME + m_Varlist.GetColOffset(), vsNames, 0, true);
		m_Varlist.ResizeCols();
		EnableButtons(vsRanges.GetSize());
		GetItem(IDC_MATLAB_REMOVE_BTN).Enable = false;	//----Folger 07/24/07 CONTROL_REMOVE_BEHAVIOR
		GetItem(IDC_MATLAB_EXPORT_NUN_BTN).Enable = false;	//----Folger 07/25/07 EXPORT_SELECTED_TO_MATLAB_ONLY
	}
	BOOL OnRemove(Control ctrl)
	{
		int nRowOffset = m_Varlist.GetRowOffset();
		int nColOffset = m_Varlist.GetColOffset();
		vector<uint> vnRows;
		m_Varlist.GetSelRows(vnRows);
		int nSelRow = m_Varlist.GetSelectedRow();		//----Folger 07/24/07 CONTROL_REMOVE_BEHAVIOR
		for(int ii = vnRows.GetSize() - 1; ii >= 0; ii--)
		{
			int nRow = vnRows[ii];
			if(nRow < nRowOffset)
				continue;			
			m_Varlist.DeleteRow(nRow);
		}
		vector<string> vsRanges, vsNames;
		m_Varlist.GetColValues(COL_RANGE + nColOffset, vsRanges, nRowOffset);
		m_Varlist.GetColValues(COL_NAME + nColOffset, vsNames, nRowOffset);
		setArrays(vsRanges, vsNames);	
		EnableButtons(vsRanges.GetSize());
		selectRow(nSelRow);			//----Folger 07/24/07 CONTROL_REMOVE_BEHAVIOR
		return TRUE;
	}
	
	///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
	/*
	BOOL ExportToMatlabRealMatrice(LPCSTR lpcszName, DataRange dr, string& strResult = NULL)
	{
		matrix mm;
		string strMatlabVar(lpcszName);
		DWORD dwRules = DRR_NO_FACTORS;
		if(dr.GetData(mm, dwRules) != 1)
			return FALSE;
	
		ocu_NANUM_to_nan((double *)mm, mm.GetNumRows() * mm.GetNumCols());	
		matrix m1;
		m1 = mm; m1 = 0;
		bool bSucsess = m_matObj.PutMatrix(strMatlabVar, &mm, &m1);
		if(!bSucsess)
		{
			//strResult = _L("Failed to real export data to"); 
			//strResult += " " + strMatlabVar;
			return FALSE;
		}
		
		return TRUE;
	}
	*/
	BOOL ExportToMatlabNumMatrice(LPCSTR lpcszName, DataRange dr, string& strResult = NULL)
	{
		matrix<complex> mat;
		string strMatlabVar(lpcszName);
		DWORD dwRules = DRR_NO_FACTORS | DRR_COMPLEX;
		if(dr.GetData(mat, dwRules) != 1)
			return FALSE;
	
		matrix mmR, mmI;
		mat.GetReal(mmR);
		mat.GetImaginary(mmI);
	
		if(mmI.GetNumRows()!=mmR.GetNumRows() || mmI.GetNumCols()!=mmR.GetNumCols())
		{
			//strResult = "\r\n" + _L("Inconsistent Matrix Size.");
			return FALSE;
		}
		
		ocu_NANUM_to_nan((double *)mmR, mmR.GetNumRows() * mmR.GetNumCols());
		ocu_NANUM_to_nan((double *)mmI, mmI.GetNumRows() * mmI.GetNumCols());
		
		bool bSuccess = m_matObj.PutMatrix(strMatlabVar, &mmR, &mmI);
		if(!bSuccess)
		{
			//strResult = _L("Failed to export complex data to"); 
			//strResult += " " + strMatlabVar;
			return FALSE;
		}
		
		return TRUE;
	}
	
	BOOL ExportToMatlabString(LPCSTR lpcszName, DataRange dr, string& strResult = NULL)
	{
		vector<string> strVec;
		string strMatlabVar(lpcszName);
		if(!dr.GetData(&strVec, 0))
		{
			//strResult = _L("Rang type is not string!"); 
			return FALSE;
		}
		
		string str;
		makeStrVectorToStr(strVec, str);
			
		string strCmd;
		strCmd.Format("%s = cellstr(%s)", strMatlabVar, str);
		string strErrMsg;
		bool bSuccess = m_matObj.Execute(strCmd, strErrMsg);
		if(!bSuccess)
		{
			//strResult = _L("Failed to export string data to"); 
			//strResult += " " + strMatlabVar;
			return FALSE;
		}
		
		return TRUE;
	}
	///end ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
	
	BOOL OnExport(Control ctrl)
	{
		///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
		//getArrays(vsRanges, vsNames);	
		if(m_matObj.Attach( TRUE, m_bSingle ))
		{
			vector<string> vsRanges, vsNames;
			vector<uint> vnSelected, vnSuccess;	///Jasmine 07/6/07 CANCEL_GRID_SELECTION
			m_Varlist.GetSelRows(vnSelected);
			//----Folger 07/25/07 EXPORT_SELECTED_TO_MATLAB_ONLY
			//int nObjectType = getArrays(vsRanges, vsNames);
			int nObjectType = getSelectedItems(vsRanges, vsNames);
			//----End EXPORT_SELECTED_TO_MATLAB_ONLY
			int nSize = vsRanges.GetSize();
			for(int ii = 0; ii < nSize; ii++)
			{
				DataRange dr;
				bool bTextCol = false;
				if(TAB_COLUMN_TYPE == nObjectType)
				{
					dr.Create(vsRanges[ii], XVT_DATARANGE);
					DWORD dwRules = DRR_NO_FACTORS | DRR_COMPLEX;
					string strData;
					dr.GetData(dwRules, 0, &strData);
					DatasetObject dobj(strData);
					int nn = dobj.PercentText();
					if(nn > 50)
						bTextCol = true;
				}
				
				if(TAB_MATRIX_TYPE == nObjectType)
					dr.Create(vsRanges[ii], XVT_DATARANGE);
				
				BOOL bExportSuccess = FALSE;
				if(bTextCol)
					bExportSuccess = ExportToMatlabString(vsNames[ii], dr);
				else
					bExportSuccess = ExportToMatlabNumMatrice(vsNames[ii], dr);
				//------Folger 07/25/07 ADD_MATLAB_EXPORT_INFO
				//if(!bExportSuccess)
				//{
					//string strErrMsg = "Failed to export " + vsRanges[ii] + " to " + vsNames[ii];
					//MessageBox(GetSafeHwnd(), strErrMsg, NULL, MB_OK);
				    //return FALSE;
				//}
				string strMsg;
				ocu_load_msg_str(bExportSuccess ? XF_EXPORT_SUCCESS : XF_EXPORT_FAILED,
								&strMsg, vsRanges[ii], NULL, vsNames[ii]);
				if (bExportSuccess)
				{
					okoc_out_msg(strMsg, 'I');
					vnSuccess.Add(vnSelected[ii]);	///Jasmine 07/6/07 CANCEL_GRID_SELECTION
				}
				else
					okoc_out_msg(strMsg);//, 'I');
				//------End ADD_MATLAB_EXPORT_INFO
			}
			///Jasmine 07/6/07 CANCEL_GRID_SELECTION
			m_Varlist.CancelSelRows(vnSuccess);
			EnableButtons(nSize > vnSuccess.GetSize());
			///End CANCEL_GRID_SELECTION
		}
		else
			GetWindow().Text = STR_NO_MATLAB;
		
		m_matObj.Detach();
		
		return TRUE;
		///end ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
	}
	///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
	/*
	BOOL OnExportStr(Control ctrl)
	{
		///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
		if(m_matObj.Attach( TRUE, m_bSingle ))
		{
			vector<string> vsRanges, vsNames;
			int nObjectType = getArrays(vsRanges, vsNames);
			for(int ii = 0; ii < vsRanges.GetSize(); ii++)
			{
				DataRange dr;
				if(TAB_COLUMN_TYPE == nObjectType)
					dr.Create(vsRanges[ii], XVT_DATARANGE);
				if(TAB_MATRIX_TYPE == nObjectType)
					dr.Create(vsRanges[ii], XVT_DATARANGE);
				
				//string strResult;
				if( !ExportToMatlabString(vsNames[ii], dr) )
				{
					string strErrMsg = "Failed to export " + vsRanges[ii] + " to " + vsNames[ii];
					MessageBox(GetSafeHwnd(), strErrMsg, NULL, MB_OK);
				    return FALSE;
				}
			}
			
		}
		else
			GetWindow().Text = STR_NO_MATLAB;
		
		m_matObj.Detach();
		///end ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
		return TRUE;
	}
	*/
	///end ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		GetItem(IDC_MATLAB_REMOVE_BTN).Enable = true;	//----Folger 07/24/07 CONTROL_REMOVE_BEHAVIOR
		GetItem(IDC_MATLAB_EXPORT_NUN_BTN).Enable = true;	//----Folger 07/25/07 EXPORT_SELECTED_TO_MATLAB_ONLY
		if(COL_NAME + m_Varlist.GetColOffset() == nCol)
		{
			m_strOldValue = m_Varlist.GetCell(nRow, nCol);
		}
		else
		{
			*pCancel = true;
		}
	}
	void OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		if(COL_NAME + m_Varlist.GetColOffset() == nCol)
		{
			vector<string> vsNames;
			getArrays(NULL, vsNames);
		
			string strNewValue = m_Varlist.GetCell(nRow, nCol);
			if(!strNewValue.CompareNoCase(m_strOldValue))
				return;
			strNewValue.MakeValidCName();
			m_Varlist.SetCell(nRow, nCol, strNewValue);
			int nIndex = vsNames.Find(strNewValue);
			if(-1 < nIndex && nIndex != nRow - m_Varlist.GetRowOffset())
			{
				MessageBox(GetSafeHwnd(), _L("The name you specified already exists. Please specify a different variable name."), NULL, MB_OK);
				m_Varlist.SetCell(nRow, nCol, m_strOldValue);	
				return;
			}
			m_Varlist.GetColValues(COL_NAME + m_Varlist.GetColOffset(), vsNames, m_Varlist.GetRowOffset());
			setArrays(NULL, vsNames);
		}
	}
	string GetVarNameFromRange(LPCSTR lpcszRange)
   	{
   		string strSheet, strCol1, strCol2;
		int c1, c2;
		Datasheet ds;
		DataRange dr;
		okxf_init_range_from_string(&dr, lpcszRange);

		if(dr)
			 dr.GetRange(ds, c1, c2);
		if(ds)
		{
			ds.GetName(strSheet);
			int nType = ds.GetPage().GetType();
			if(EXIST_WKS == nType)
			{
				Worksheet wks(ds);
				strCol1 = wks.Columns(c1).GetName();
				if(c1 != c2)
					strCol2 = wks.Columns(c2).GetName();
			}
			if(EXIST_MATRIX == nType)
			{
				MatrixLayer ml(ds);
				strCol1 = ml.MatrixObjects(c1).GetName();
				if(c1 != c2)
					strCol2 = ml.MatrixObjects(c2).GetName();
			}
			if(!strCol1.IsEmpty())
				strSheet += "_" + strCol1;
			if(!strCol2.IsEmpty())
				strSheet += strCol2;
		}
		okutil_make_valid_c_name(&strSheet);
   		return strSheet;
   	}
   	void EnableButtons(bool bEnable)
   	{
   		GetItem(IDC_MATLAB_REMOVE_BTN).Enable = bEnable;
   		GetItem(IDC_MATLAB_EXPORT_NUN_BTN).Enable = bEnable;
   		//GetItem(IDC_MATLAB_EXPORT_STR_BTN).Enable = bEnable; ///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX	
   	}
private:
	///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
   	//void getArrays(vector<string>& vsRanges = NULL, vector<string>& vsNames = NULL)
   	int getArrays(vector<string>& vsRanges = NULL, vector<string>& vsNames = NULL)
   	///END ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
   	{
   		int nSel = m_tab.GetCurSel();
   		if(TAB_COLUMN_TYPE == nSel)
   		{
   			if(vsRanges)
   				vsRanges = m_vsColRanges;
   			if(vsNames)
				vsNames = m_vsColNames;
   		}
		if(TAB_MATRIX_TYPE == nSel)
		{
   			if(vsRanges)
   				vsRanges = m_vsMatRanges;
   			if(vsNames)
				vsNames = m_vsMatNames;
		}
		return nSel;	///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
   	}
   	void setArrays(const vector<string>& vsRanges = NULL, const vector<string>& vsNames = NULL)
   	{
   		int nSel = m_tab.GetCurSel();
   		if(TAB_COLUMN_TYPE == nSel)
   		{
   			if(vsRanges)
   				m_vsColRanges = vsRanges;
   			if(vsNames)
				m_vsColNames = vsNames;
   		}
		if(TAB_MATRIX_TYPE == nSel)
		{
   			if(vsRanges)
   				m_vsMatRanges = vsRanges;
   			if(vsNames)
				m_vsMatNames = vsNames;
		}
   	}
   	void _get_column_name(string& strCol)
   	{
   		int nIndex = strCol.Find("(");
   		if(0 <= nIndex)
   			strCol.Delete(0, nIndex + 1);
   		strCol.TrimRight(")");
   	}
   	///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
   	int getLengths(vector<string>& vs, vector<int> &vret)
	{
		int nMaxWidth = 0;
		int nTemp;
		int nSize = vs.GetSize();
		
		vret.SetSize(nSize);
		for(int ii = 0; ii < nSize; ii++)
		{
			nTemp = lstrlen(vs[ii]);
			if( nTemp > nMaxWidth )
				nMaxWidth = nTemp;
			
			vret[ii] = nTemp;
		}
		
		return nMaxWidth;
	}
	
   	void checkAndPadding(vector<string>& vs)
	{
		vector<int> vlen;
		int nMaxLen = getLengths(vs, vlen);

		int iNumPad;
		for( int ii = 0; ii < vlen.GetSize(); ii++ )
		{
			iNumPad = nMaxLen - vlen[ii];
			if( iNumPad > 0 )
			{
				while( iNumPad-- > 0 )
					vs[ii] += " ";
			}
		}
	}
	
	void makeStrVectorToStr(vector<string>& vs, string& str)
	{
		if( 0 == vs.GetSize() )
			return;
		
		str = "[";
		checkAndPadding(vs);
		
		for( int ii = 0; ii < vs.GetSize(); ii++)
		{
			str += "\'"+ vs[ii] + "\';";
		}
		str.Delete( str.GetLength() - 1 ); 
		str += "]";
	}
	///end ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
	//----Folger 07/24/07 CONTROL_REMOVE_BEHAVIOR
	void selectRow(int nRow = -1)
	{
		if(m_Varlist.GetRows() <= 0)
			return;
		
		while(nRow >= m_Varlist.GetRows())
			nRow--;
			
		if(nRow < 0)
			nRow = m_Varlist.GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
		if( nRow < 0 )
			nRow = 0;
		
		if (nRow != 0) m_Varlist.SelRow(nRow);	
	}
	//----End CONTROL_REMOVE_BEHAVIOR
	//----Folger 07/25/07 EXPORT_SELECTED_TO_MATLAB_ONLY
	int getSelectedItems(vector<string> &vsRanges, vector<string> &vsNames)
	{
		int nSel = m_tab.GetCurSel();
		vector<uint> vnSelected;
		m_Varlist.GetSelRows(vnSelected);
		vnSelected -= m_Varlist.GetRowOffset();
		int nSize = vnSelected.GetSize();
		vsRanges.SetSize(nSize);
		vsNames.SetSize(nSize);
		if (nSel == TAB_COLUMN_TYPE)
		{
			for (int ii=0; ii<nSize; ii++)
			{
				vsRanges[ii] = m_vsColRanges[vnSelected[ii]];
				vsNames[ii] = m_vsColNames[vnSelected[ii]];
			}
		}
		else if (nSel == TAB_MATRIX_TYPE)
		{
			for (int ii=0; ii<nSize; ii++)
			{
				vsRanges[ii] = m_vsMatRanges[vnSelected[ii]];
				vsNames[ii] = m_vsMatNames[vnSelected[ii]];
			}
		}
		return nSel;
	}
	//----End EXPORT_SELECTED_TO_MATLAB_ONLY
private:
	TabControl		m_tab;
	GridListControl m_Varlist;
	vector<string>	m_vsColRanges;
	vector<string>	m_vsMatRanges;
	vector<string>	m_vsColNames;
	vector<string>	m_vsMatNames;
	string			m_strOldValue;
	string			m_strMatlabWorkspaceFilename;
	bool			m_bSingle;
	Matlab 			m_matObj; ///Arvin 07/16/07 v8.0660 ORIGIN_OBJECT_EXPORT_TO_MATLAB_MATRIX
};

#endif //_MATLAB_EXPORTDLG_H
